/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.item.LeftoversCreatedEvent;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.duck.PlayerDuck;
import com.cobblemon.mod.common.duck.RidePassenger;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokedex.scanner.PokedexEntityData;
import com.cobblemon.mod.common.pokedex.scanner.ScannableEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.CompoundTagExtensionsKt;
import com.cobblemon.mod.common.util.CompoundTagUtilities;
import com.cobblemon.mod.common.world.gamerules.CobblemonGameRules;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4174;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
extends class_1309
implements ScannableEntity,
OrientationControllable,
PlayerDuck,
RidePassenger {
    @Unique
    private Vector3f cobblemon$driverInput;
    @Unique
    private Vector3f cobblemon$lastSentDriverInput;
    @Shadow
    @Final
    private static Map<class_4050, class_4048> field_18134;
    @Shadow
    @Final
    public static class_4048 field_18135;
    @Shadow
    protected int field_7489;
    @Unique
    private final OrientationController cobblemon$orientationController = new OrientationController(this);
    @Unique
    private float cobblemon$rideXRot = 0.0f;
    @Unique
    private float cobblemon$rideYRot = 0.0f;
    @Unique
    private class_243 cobblemon$rideEyePos = class_243.field_1353;

    @Shadow
    public abstract class_2487 method_7356();

    @Shadow
    public abstract class_2487 method_7308();

    @Shadow
    public abstract void method_7296(class_2487 var1);

    @Shadow
    public abstract void method_7345(class_2487 var1);

    @Shadow
    public abstract void method_7273(class_2487 var1);

    @Shadow
    public abstract boolean method_7325();

    @Shadow
    public abstract boolean method_7270(class_1799 var1);

    @Shadow
    public abstract void method_7353(class_2561 var1, boolean var2);

    protected PlayerMixin(class_1299<? extends class_1309> p_20966_, class_1937 p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(method={"respawnEntityOnShoulder"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/EntityType;create(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;")}, cancellable=true)
    private void cobblemon$removePokemon(class_2487 nbt, CallbackInfo ci) {
        if (CompoundTagExtensionsKt.isPokemonEntity(nbt)) {
            UUID uuidLeft;
            UUID uuidRight;
            UUID uuid = CompoundTagUtilities.getPokemonID(nbt);
            if (CompoundTagUtilities.isShoulderPokemon(this.method_7308()) && uuid.equals(uuidRight = CompoundTagUtilities.getPokemonID(this.method_7308()))) {
                this.recallPokemon(uuidRight);
                this.method_7345(new class_2487());
            }
            if (CompoundTagUtilities.isShoulderPokemon(this.method_7356()) && uuid.equals(uuidLeft = CompoundTagUtilities.getPokemonID(this.method_7356()))) {
                this.recallPokemon(uuidLeft);
                this.method_7273(new class_2487());
            }
            ci.cancel();
        }
    }

    public class_4048 method_55694(class_4050 pose) {
        if (this.method_5854() instanceof PokemonEntity) {
            return field_18135;
        }
        return field_18134.getOrDefault(pose, field_18135);
    }

    @Inject(method={"removeEntitiesOnShoulder"}, at={@At(value="JUMP", opcode=156, ordinal=0, shift=At.Shift.AFTER)}, cancellable=true)
    private void cobblemon$preventPokemonDropping(CallbackInfo ci) {
        if (this.method_7325() || this.method_29504()) {
            return;
        }
        if (!CompoundTagUtilities.isShoulderPokemon(this.method_7356())) {
            this.method_7296(this.method_7356());
            this.method_7273(new class_2487());
        }
        if (!CompoundTagUtilities.isShoulderPokemon(this.method_7308())) {
            this.method_7296(this.method_7308());
            this.method_7345(new class_2487());
        }
        ci.cancel();
    }

    private void recallPokemon(UUID uuid) {
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(this.method_5667(), this.method_56673());
        for (Pokemon pokemon : party) {
            if (!pokemon.getUuid().equals(uuid)) continue;
            pokemon.recall();
        }
    }

    @Inject(method={"eat"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getFoodData()Lnet/minecraft/world/food/FoodData;", shift=At.Shift.AFTER)})
    public void onEatFood(class_1937 world, class_1799 stack, class_4174 foodComponent, CallbackInfoReturnable<class_1799> cir) {
        if (!this.method_37908().field_9236 && stack.method_31573(CobblemonItemTags.LEAVES_LEFTOVERS) && this.method_37908().field_9229.method_43058() < Cobblemon.config.getAppleLeftoversChance()) {
            class_1799 leftovers = new class_1799((class_1935)CobblemonItems.LEFTOVERS);
            class_3222 player = Objects.requireNonNull(this.method_5682()).method_3760().method_14602(this.field_6021);
            assert (player != null);
            CobblemonEvents.LEFTOVERS_CREATED.postThen(new LeftoversCreatedEvent(player, leftovers), (Function1<LeftoversCreatedEvent, Unit>)((Function1)leftoversCreatedEvent -> null), (Function1<LeftoversCreatedEvent, Unit>)((Function1)leftoversCreatedEvent -> {
                if (!player.method_7270(leftoversCreatedEvent.getLeftovers())) {
                    class_243 itemPos = player.method_5720().method_1021(0.5).method_1019(this.method_19538());
                    this.method_37908().method_8649((class_1297)new class_1542(this.method_37908(), itemPos.method_10216(), itemPos.method_10214(), itemPos.method_10215(), leftoversCreatedEvent.getLeftovers()));
                }
                return null;
            }));
        }
    }

    @Inject(method={"isInvulnerableTo"}, at={@At(value="HEAD")}, cancellable=true)
    public void isInvulnerableTo(class_1282 source, CallbackInfoReturnable<Boolean> ci) {
        PlayerMixin playerMixin;
        if (!this.method_37908().field_9236 && (playerMixin = this) instanceof class_3222) {
            boolean inBattle;
            class_3222 player = (class_3222)playerMixin;
            boolean invulnerableInBattle = this.method_37908().method_8450().method_8355(CobblemonGameRules.BATTLE_INVULNERABILITY);
            Cobblemon.INSTANCE.getBattleRegistry();
            boolean bl = inBattle = BattleRegistry.getBattleByParticipatingPlayer(player) != null;
            if (invulnerableInBattle && inBattle) {
                ci.setReturnValue((Object)true);
            }
        }
    }

    @Override
    @Nullable
    public PokedexEntityData resolvePokemonScan() {
        if (CompoundTagUtilities.isShoulderPokemon(this.method_7308())) {
            return this.getDataFromShoulderPokemon(this.method_7308());
        }
        if (CompoundTagUtilities.isShoulderPokemon(this.method_7356())) {
            return this.getDataFromShoulderPokemon(this.method_7356());
        }
        return null;
    }

    @Unique
    @Nullable
    private PokedexEntityData getDataFromShoulderPokemon(class_2487 shoulderTag) {
        Pokemon pokemon;
        if (this.method_37908().field_9236) {
            class_2487 pokemonTag = shoulderTag.method_10562("Pokemon");
            if (pokemonTag.method_33133()) {
                return null;
            }
            Species species = PokemonSpecies.getByIdentifier(class_2960.method_60654((String)pokemonTag.method_10558("Species")));
            if (species == null) {
                return null;
            }
            String formId = pokemonTag.method_10558("FormId");
            FormData form = species.getStandardForm();
            List<FormData> formList = species.getForms().stream().filter(it -> it.formOnlyShowdownId().equals(formId)).toList();
            if (!formList.isEmpty()) {
                form = formList.getFirst();
            }
            if (form == null) {
                return null;
            }
            String genderString = pokemonTag.method_10558("Gender");
            if (genderString.isEmpty()) {
                return null;
            }
            Gender gender = Gender.valueOf(genderString);
            boolean shiny = pokemonTag.method_10577("Shiny");
            int level = pokemonTag.method_10550("Level");
            Set<String> aspects2 = shoulderTag.method_10554("shoulder_aspects", 8).stream().map(class_2520::method_10714).collect(Collectors.toSet());
            pokemon = new Pokemon();
            pokemon.setSpecies(species);
            pokemon.setForm(form);
            pokemon.setGender(gender);
            pokemon.setShiny(shiny);
            pokemon.setLevel(level);
            pokemon.setForcedAspects(aspects2);
        } else {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(this.method_5667(), this.method_56673());
            pokemon = party.get(shoulderTag.method_25926("shoulder_uuid"));
        }
        return pokemon == null ? null : new PokedexEntityData(pokemon, null);
    }

    @Override
    public class_1309 resolveEntityScan() {
        return this;
    }

    public void method_5641(double x, double y, double z, float yaw, float pitch) {
        if (this.cobblemon$orientationController.getActive()) {
            this.method_30634(x, y, z);
            this.method_36456(yaw % 360.0f);
            this.method_36457(pitch % 360.0f);
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        } else {
            this.method_30634(x, y, z);
            this.method_60608(yaw, pitch);
        }
    }

    @WrapOperation(method={"rideTick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;wantsToStopRiding()Z")})
    public boolean delegateDismountToController(class_1657 instance, Operation<Boolean> original) {
        class_1297 class_12972 = this.method_5854();
        if (class_12972 instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)class_12972;
            return pokemonEntity.ifRidingAvailableSupply(false, (behaviour, settings, state) -> behaviour.dismountOnShift(settings, state, pokemonEntity) && (Boolean)original.call(new Object[]{instance}) != false);
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @Override
    public OrientationController getOrientationController() {
        return this.cobblemon$orientationController;
    }

    @Override
    public void setDriverInput(Vector3f driverInput) {
        this.cobblemon$driverInput = driverInput;
    }

    @Override
    public Vector3f getDriverInput() {
        return this.cobblemon$driverInput;
    }

    @Override
    public void setLastSentDriverInput(Vector3f lastSentDriverInput) {
        this.cobblemon$lastSentDriverInput = lastSentDriverInput;
    }

    @Override
    public Vector3f getLastSentDriverInput() {
        return this.cobblemon$lastSentDriverInput;
    }

    @Override
    public float cobblemon$getRideXRot() {
        return this.cobblemon$rideXRot;
    }

    @Override
    public void cobblemon$setRideXRot(float rideXRot) {
        this.cobblemon$rideXRot = class_3532.method_15393((float)rideXRot);
    }

    @Override
    public float cobblemon$getRideYRot() {
        return this.cobblemon$rideYRot;
    }

    @Override
    public void cobblemon$setRideYRot(float rideYRot) {
        this.cobblemon$rideYRot = class_3532.method_15393((float)rideYRot);
    }

    @Override
    public class_243 cobblemon$getRideEyePos() {
        return this.cobblemon$rideEyePos;
    }

    @Override
    public void cobblemon$setRideEyePos(class_243 rideEyePos) {
        this.cobblemon$rideEyePos = rideEyePos;
    }
}

